# Swift Syntax 510 Release Notes

## New APIs

- `SyntaxStringInterpolation.appendInterpolation(_: (some SyntaxProtocol)?)`
  - Description: Allows optional syntax nodes to be used inside string interpolation of syntax nodes. If the node is `nil`, nothing will get added to the string interpolation.
  - Pull Request: https://github.com/apple/swift-syntax/pull/2085

- `SyntaxCollection.index(at:)`
  - Description: Returns the index of the n-th element in a `SyntaxCollection`. This computation is in O(n) and `SyntaxCollection` is not subscriptable by an integer.
  - Pull Request: https://github.com/apple/swift-syntax/pull/2014

- Convenience initializer `ClosureCaptureSyntax.init()`
  - Description: Provides a convenience initializer for `ClosureCaptureSyntax` that takes a concrete `name` argument and automatically adds `equal = TokenSyntax.equalToken()` to it.
  - Issue: https://github.com/apple/swift-syntax/issues/1984
  - Pull Request: https://github.com/apple/swift-syntax/pull/2127

- Convenience initializer `EnumCaseParameterSyntax.init()`
  - Description: Provides a convenience initializer for `EnumCaseParameterSyntax` that takes a concrete `firstName` value and adds `colon = TokenSyntax.colonToken()` automatically to it.
  - Issue: https://github.com/apple/swift-syntax/issues/1984
  - Pull Request: https://github.com/apple/swift-syntax/pull/2112

- `DiagnosticSeverity` and `PluginMessage.Diagnostic.Severity` now have new case named `remark`
  - Description: Remarks are used by the Swift compiler and other tools to describe some aspect of translation that doesn't reflect correctness, but may be useful for the user. Remarks have been added to the diagnostic severity enums to align with the Swift compiler.
  - Pull Request: https://github.com/apple/swift-syntax/pull/2143

## API Behavior Changes

## Deprecations

- Leaf Node Casts
  - Description: Syntax nodes that do not act as base nodes for other syntax types have the casting methods marked as deprecated. This prevents unsafe type-casting by issuing deprecation warnings for methods that will always result in failed casts.
  - Issue: https://github.com/apple/swift-syntax/issues/2092
  - Pull Request: https://github.com/apple/swift-syntax/pull/2108

- Same-Type Casts
  - Description: `is`, `as`, and `cast` overloads on `SyntaxProtocol` with same-type conversions are marked as deprecated. The deprecated methods emit a warning indicating the cast will always succeed.
  - Issue: https://github.com/apple/swift-syntax/issues/2092
  - Pull Request: https://github.com/apple/swift-syntax/pull/2108

- Base Node Casts
  - Description: `is`, `as`, and `cast` methods on base node protocols with base-type conversions are marked as deprecated. The deprecated methods emit a warning that informs the developer that the cast will always succeed and should be done using the base node's initializer.
  - Issue: https://github.com/apple/swift-syntax/issues/2092
  - Pull Request: https://github.com/apple/swift-syntax/pull/2108

- `WildcardPatternSyntax.typeAnnotation`
  - Description: `typeAnnotation` on `WildcardPatternSyntax` was a mistake. Use `typeAnnotation` properties on the outer constructs instead. E.g. `PatternBindingListSyntax.typeAnnotation`
  - Pull Request: https://github.com/apple/swift-syntax/pull/2393

## API-Incompatible Changes

- `NoteMessage.fixItID` renamed to `noteID`
  - Description: This was an error that it was named `fixItID` and should have been named `noteID` instead. Accesses to `fixItID` are deprecated and forward to `noteID`. Any types that conform `NoteMessage` it will need to be updated to provide a `noteID` instead of a `fixItID`.
  - Issue: https://github.com/apple/swift-syntax/issues/2261
  - Pull Request: https://github.com/apple/swift-syntax/pull/2264

- `DiagnosticSpec.highlight` replaced by `highlights`
  - Description: The use of a single string `highlight` prevented users from asserting that a macro highlighted exactly the expected set of syntax nodes. Use of `DiagnosticSpec.init(...highlight:...)` is deprecated and forwards to `DiagnosticSpec.init(...highlights:...)`. Migrating from `highlight` to `highlights` is straightforward; any uses of `DiagnosticSpec.init` which do not specify a `highlight` do not need to change, otherwise:
    - If the diagnostic highlights a single node, the `highlight` string should be replaced with a single element array containing the same string without any trailing trivia, e.g., `highlight: "let "` -> `highlights: ["let"]`.
    - If the diagnostic highlights multiple nodes, the `highlight` string should be replaced with an array containing an element for each highlighted node, e.g., `highlight: "struct {}"` -> `highlights: ["struct", "{}"]`.
  - Pull Request: https://github.com/apple/swift-syntax/pull/2213

## Template

- *Affected API or two word description*
  - Description: *A 1-2 sentence description of the new/modified API*
  - Issue: *If an issue exists for this change, a link to the issue*
  - Pull Request: *Link to the pull request(s) that introduces this change*
  - Notes: *In case of deprecations or API-incompatible changes, the reason why this change was made and the suggested alternative*

*Insert entries in chronological order, with newer entries at the bottom*
